/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.StringInterner;

public class TextDecoder {
    private StringInterner interner = new StringInterner();
    private char[] source;
    private int count;
    private int start;

    public TextDecoder(char[] source) {
        this(source, 0, source.length);
    }

    public TextDecoder(char[] source, int off, int count) {
        this.source = source;
        this.count = count;
        this.start = off;
    }

    public String decode(int off, int length) {
        return this.decode(off, length, true);
    }

    public String decode(int off, int length, boolean escape) {
        int limit = this.start + length + off;
        int read = this.start + off;
        int write = 0;
        if (length > 0 && escape) {
            char[] result = new char[length];
            while (read < limit) {
                char current = this.source[read];
                if (current == '\\' && read + 1 < limit) {
                    char next = this.source[read + 1];
                    if (next == 'u' || next == 'U') {
                        result[write++] = this.escape(read + 2, 4);
                        read += 6;
                        continue;
                    }
                    if (this.literal(next)) {
                        result[write++] = this.source[read + 1];
                    } else if (next == 'r') {
                        result[write++] = 13;
                    } else if (next == 'b') {
                        result[write++] = 8;
                    } else if (next == 'n') {
                        result[write++] = 10;
                    } else if (next == 't') {
                        result[write++] = 9;
                    } else if (next == 'f') {
                        result[write++] = 12;
                    }
                    read += 2;
                    continue;
                }
                result[write++] = this.source[read++];
            }
            return this.interner.intern(result, 0, write);
        }
        return this.interner.intern(this.source, off, length);
    }

    private char escape(int off, int length) {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            char next = this.source[off + i];
            value <<= 4;
            value |= this.hexidecimal(next);
        }
        return (char)value;
    }

    private boolean literal(char value) {
        switch (value) {
            case '\"': 
            case '\'': 
            case '\\': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    public int binary(char value) {
        if (value == '0') {
            return 0;
        }
        if (value == '1') {
            return 1;
        }
        throw new IllegalArgumentException("Character '" + value + "' is not binary");
    }

    public int hexidecimal(char value) {
        if (value >= '0' && value <= '9') {
            return value - 48;
        }
        if (value >= 'a' && value <= 'f') {
            return 10 + (value - 97);
        }
        if (value >= 'A' && value <= 'F') {
            return 10 + (value - 65);
        }
        throw new IllegalArgumentException("Character '" + value + "' is not hexidecimal");
    }
}

