/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.NumberType;
import org.snapscript.parse.NumberTypeMatcher;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.TextDecoder;

public class TextReader {
    private NumberTypeMatcher matcher;
    private TextDecoder decoder;
    private short[] types;
    private char[] source;
    private int count;
    private int off;

    public TextReader(char[] source, short[] types) {
        this(source, types, 0, source.length);
    }

    public TextReader(char[] source, short[] types, int off, int count) {
        this.decoder = new TextDecoder(source, off, count);
        this.matcher = new NumberTypeMatcher();
        this.source = source;
        this.count = count;
        this.types = types;
        this.off = off;
    }

    public Character peek() {
        if (this.off < this.count) {
            return Character.valueOf(this.source[this.off]);
        }
        return null;
    }

    public Character next() {
        if (this.off < this.count) {
            return Character.valueOf(this.source[this.off++]);
        }
        return null;
    }

    public Character literal(char value) {
        char next;
        if (this.off < this.count && (next = this.source[this.off]) == value) {
            ++this.off;
            return Character.valueOf(next);
        }
        return null;
    }

    public String literal(char[] text) {
        int length = text.length;
        int mark = this.off;
        if (this.count - this.off >= length) {
            for (int i = 0; i < length; ++i) {
                char value = text[i];
                char next = this.source[this.off + i];
                if (value == next) continue;
                return null;
            }
            this.off += length;
            return this.decoder.decode(mark, length, false);
        }
        return null;
    }

    public String literal(String text) {
        int length = text.length();
        if (this.count - this.off >= length) {
            for (int i = 0; i < length; ++i) {
                char next;
                char value = text.charAt(i);
                if (value == (next = this.source[this.off + i])) continue;
                return null;
            }
            this.off += length;
            return text;
        }
        return null;
    }

    public Character space() {
        short type;
        if (this.off < this.count && ((type = this.types[this.off]) & 0x4000) == 16384) {
            return Character.valueOf(this.source[this.off++]);
        }
        return null;
    }

    public Character letter() {
        short type;
        if (this.off < this.count && ((type = this.types[this.off]) & 1) == 1) {
            return Character.valueOf(this.source[this.off++]);
        }
        return null;
    }

    public Character digit() {
        short type;
        if (this.off < this.count && ((type = this.types[this.off]) & 2) == 2) {
            return Character.valueOf(this.source[this.off++]);
        }
        return null;
    }

    public Number binary() {
        if (this.off + 3 < this.count) {
            int pos;
            char first = this.source[this.off];
            char second = this.source[this.off + 1];
            if (first != '0') {
                return null;
            }
            if (second != 'b' && second != 'B') {
                return null;
            }
            NumberType type = NumberType.INTEGER;
            int mark = this.off;
            int value = 0;
            for (pos = this.off + 2; pos < this.count; ++pos) {
                short mask = this.types[pos];
                char next = this.source[pos];
                if ((mask & 8) == 8) {
                    value <<= 1;
                    value |= this.decoder.binary(next);
                    continue;
                }
                if ((mask & 0x100) != 256) break;
                type = this.matcher.match(next);
                ++this.off;
                break;
            }
            if (pos > mark + 2) {
                this.off = pos;
                return type.convert(value);
            }
        }
        return null;
    }

    public Number hexidecimal() {
        if (this.off + 3 < this.count) {
            int pos;
            char first = this.source[this.off];
            char second = this.source[this.off + 1];
            if (first != '0') {
                return null;
            }
            if (second != 'x' && second != 'X') {
                return null;
            }
            NumberType type = NumberType.INTEGER;
            int mark = this.off;
            int value = 0;
            for (pos = this.off + 2; pos < this.count; ++pos) {
                short mask = this.types[pos];
                char next = this.source[pos];
                if ((mask & 4) == 4) {
                    value <<= 4;
                    value |= this.decoder.hexidecimal(next);
                    continue;
                }
                if ((mask & 0x100) != 256) break;
                type = this.matcher.match(next);
                ++this.off;
                break;
            }
            if (pos > mark + 2) {
                this.off = pos;
                return type.convert(value);
            }
        }
        return null;
    }

    public Number decimal() {
        NumberType type = NumberType.INTEGER;
        double scale = 0.0;
        long value = 0L;
        int mark = this.off;
        int sign = 1;
        while (this.off < this.count) {
            char next = this.source[this.off];
            short mask = this.types[this.off];
            if ((mask & 2) == 0) {
                if (this.off > mark) {
                    if ((mask & 0x80) == 128 && scale == 0.0) {
                        if (this.off + 1 >= this.count || ((mask = this.types[this.off + 1]) & 2) != 2) break;
                        type = NumberType.DOUBLE;
                        scale = 1.0;
                        ++this.off;
                        continue;
                    }
                    if ((mask & 0x100) != 256) break;
                    type = this.matcher.match(next);
                    ++this.off;
                    break;
                }
                if ((mask & 0x200) == 512 && this.off + 1 < this.count && ((mask = this.types[this.off + 1]) & 2) == 2) {
                    sign = -1;
                    ++this.off;
                    continue;
                }
                return null;
            }
            value *= 10L;
            value += (long)next;
            value -= 48L;
            scale *= 10.0;
            ++this.off;
        }
        if (this.off > mark) {
            double result = (long)sign * value;
            if (scale > 0.0) {
                result /= scale;
            }
            return type.convert(result);
        }
        return null;
    }

    public String text() {
        int mark = this.off + 1;
        int pos = this.off + 1;
        if (pos < this.count) {
            char start = this.source[this.off];
            short mask = this.types[this.off];
            char next = start;
            if ((mask & 0x20) == 32) {
                int escape = 0;
                int length = 0;
                while (pos < this.count) {
                    if ((next = this.source[pos++]) == start) {
                        this.off = pos;
                        break;
                    }
                    mask = this.types[pos - 1];
                    if ((mask & 0x400) == 1024 && pos + 1 < this.count && ((mask = this.types[pos]) & 0x800) == 2048) {
                        ++escape;
                        ++length;
                        ++pos;
                    }
                    ++length;
                }
                if (next == start && this.off > mark) {
                    return this.decoder.decode(mark, length, escape > 0);
                }
            }
        }
        return null;
    }

    public String template() {
        int mark = this.off + 1;
        int pos = this.off + 1;
        if (pos < this.count) {
            char start = this.source[this.off];
            short mask = this.types[this.off];
            char next = start;
            if ((mask & 0x40) == 64) {
                int escape = 0;
                int length = 0;
                int variable = 0;
                while (pos < this.count) {
                    if ((next = this.source[pos++]) == start) {
                        if (variable <= 0) break;
                        this.off = pos;
                        break;
                    }
                    mask = this.types[pos - 1];
                    if ((mask & 0x1000) == 4096) {
                        ++variable;
                    } else if ((mask & 0x400) == 1024 && pos + 1 < this.count && ((mask = this.types[pos]) & 0x800) == 2048) {
                        ++escape;
                        ++length;
                        ++pos;
                    }
                    ++length;
                }
                if (next == start && this.off > mark && variable > 0) {
                    return this.decoder.decode(mark, length, escape > 0);
                }
            }
        }
        return null;
    }

    public String type() {
        short type;
        int mark = this.off;
        if (this.off < this.count && ((type = this.types[this.off]) & 0x2000) == 8192) {
            int length = 0;
            while (this.off < this.count && ((type = this.types[this.off]) & 0x1010) != 0) {
                ++length;
                ++this.off;
            }
            if (length > 0) {
                return this.decoder.decode(mark, length, false);
            }
        }
        return null;
    }

    public String identifier() {
        short type;
        int mark = this.off;
        if (this.off < this.count && ((type = this.types[this.off]) & 1) == 1) {
            int length = 0;
            while (this.off < this.count && ((type = this.types[this.off]) & 0x10) != 0) {
                ++length;
                ++this.off;
            }
            if (length > 0) {
                return this.decoder.decode(mark, length, false);
            }
        }
        return null;
    }

    public String qualifier() {
        short start;
        int mark = this.off;
        if (this.off < this.count && ((start = this.types[this.off]) & 1) == 1) {
            short next;
            int length = 0;
            while (this.off < this.count && !(((next = this.types[this.off]) & 0x1080) != 0 ? this.off + 1 < this.count && ((next = this.types[this.off + 1]) & 1) == 0 : (next & 0x10) == 0)) {
                ++length;
                ++this.off;
            }
            if (length > 0) {
                return this.decoder.decode(mark, length, false);
            }
        }
        return null;
    }

    public int reset(int mark) {
        int current = this.off;
        if (mark > this.count || mark < 0) {
            throw new ParseException("Illegal reset for position " + mark);
        }
        this.off = mark;
        return current;
    }

    public int count() {
        return this.count;
    }

    public int mark() {
        return this.off;
    }
}

