/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snapscript.parse.CharacterToken;
import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.LengthComparator;
import org.snapscript.parse.Line;
import org.snapscript.parse.LineExtractor;
import org.snapscript.parse.NumberToken;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.StringToken;
import org.snapscript.parse.TextReader;
import org.snapscript.parse.Token;
import org.snapscript.parse.TokenType;

public class TokenIndexer {
    private final LengthComparator comparator;
    private final LineExtractor extractor;
    private final GrammarIndexer indexer;
    private final TextReader reader;
    private final List<String> values;
    private final short[] lines;

    public TokenIndexer(GrammarIndexer indexer, String resource, char[] original, char[] source, short[] lines, short[] types) {
        this.extractor = new LineExtractor(resource, original);
        this.reader = new TextReader(source, types);
        this.comparator = new LengthComparator();
        this.values = new ArrayList<String>();
        this.indexer = indexer;
        this.lines = lines;
    }

    public short[] index(List<Token> tokens) {
        if (this.values.isEmpty()) {
            List<String> literals = this.indexer.list();
            for (String literal : literals) {
                this.values.add(literal);
            }
            Collections.sort(this.values, this.comparator);
        }
        return this.scan(tokens);
    }

    private short[] scan(List<Token> tokens) {
        int count = this.reader.count();
        int mark;
        while ((mark = this.reader.mark()) < count) {
            short line = this.lines[mark];
            Token token = this.literal(line);
            if (token == null) {
                token = this.space(line);
            }
            if (token == null) {
                token = this.template(line);
            }
            if (token == null) {
                token = this.text(line);
            }
            if (token == null) {
                token = this.type(line);
            }
            if (token == null) {
                token = this.identifier(line);
            }
            if (token == null) {
                token = this.binary(line);
            }
            if (token == null) {
                token = this.hexidecimal(line);
            }
            if (token == null) {
                token = this.decimal(line);
            }
            if (token == null) {
                throw new ParseException("Could not parse token at line " + this.lines[mark]);
            }
            tokens.add(token);
        }
        return this.create(tokens);
    }

    private short[] create(List<Token> tokens) {
        int length = tokens.size();
        if (length > 0) {
            short[] masks = new short[length];
            for (int i = 0; i < length; ++i) {
                Token token = tokens.get(i);
                if (token == null) continue;
                masks[i] = token.getType();
            }
            return masks;
        }
        return new short[0];
    }

    private Token type(int number) {
        Line line = this.extractor.extract(number);
        String token = this.reader.type();
        if (token != null) {
            return new StringToken(token, line, TokenType.TYPE.mask | TokenType.QUALIFIER.mask | TokenType.IDENTIFIER.mask);
        }
        return null;
    }

    private Token identifier(int number) {
        Line line = this.extractor.extract(number);
        String token = this.reader.identifier();
        if (token != null) {
            return new StringToken(token, line, TokenType.IDENTIFIER.mask | TokenType.QUALIFIER.mask);
        }
        return null;
    }

    private Token decimal(int number) {
        Line line = this.extractor.extract(number);
        Number token = this.reader.decimal();
        if (token != null) {
            return new NumberToken(token, line, TokenType.DECIMAL.mask);
        }
        return null;
    }

    private Token binary(int number) {
        Line line = this.extractor.extract(number);
        Number token = this.reader.binary();
        if (token != null) {
            return new NumberToken(token, line, TokenType.BINARY.mask | TokenType.DECIMAL.mask);
        }
        return null;
    }

    private Token hexidecimal(int number) {
        Line line = this.extractor.extract(number);
        Number token = this.reader.hexidecimal();
        if (token != null) {
            return new NumberToken(token, line, TokenType.HEXIDECIMAL.mask | TokenType.DECIMAL.mask);
        }
        return null;
    }

    private Token template(int number) {
        Line line = this.extractor.extract(number);
        String token = this.reader.template();
        if (token != null) {
            return new StringToken(token, line, TokenType.TEMPLATE.mask);
        }
        return null;
    }

    private Token text(int number) {
        Line line = this.extractor.extract(number);
        String token = this.reader.text();
        if (token != null) {
            return new StringToken(token, line, TokenType.TEXT.mask);
        }
        return null;
    }

    private Token space(int number) {
        Line line = this.extractor.extract(number);
        Character token = this.reader.space();
        if (token != null) {
            return new CharacterToken(token, line, TokenType.SPACE.mask);
        }
        return null;
    }

    private Token literal(int number) {
        Line line = this.extractor.extract(number);
        for (String literal : this.values) {
            int mark = this.reader.mark();
            String token = this.reader.literal(literal);
            if (token == null) continue;
            int length = token.length();
            Character last = Character.valueOf(token.charAt(length - 1));
            Character peek = this.reader.peek();
            if (this.identifier(last) && this.identifier(peek)) {
                this.reader.reset(mark);
                continue;
            }
            if (this.identifier(last) && this.special(peek)) {
                return new StringToken(token, line, TokenType.LITERAL.mask | TokenType.IDENTIFIER.mask | TokenType.QUALIFIER.mask);
            }
            return new StringToken(token, line, TokenType.LITERAL.mask);
        }
        return null;
    }

    private boolean identifier(Character value) {
        if (value != null) {
            if (Character.isLetter(value.charValue())) {
                return true;
            }
            if (Character.isDigit(value.charValue())) {
                return true;
            }
        }
        return false;
    }

    private boolean special(Character value) {
        if (value != null) {
            switch (value.charValue()) {
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case '?': {
                    return true;
                }
            }
        }
        return false;
    }
}

