/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.LexicalAnalyzer;
import org.snapscript.parse.Line;
import org.snapscript.parse.Token;
import org.snapscript.parse.TokenIndexer;
import org.snapscript.parse.TokenType;

public class TokenScanner
implements LexicalAnalyzer {
    private TokenIndexer indexer;
    private List<Token> tokens;
    private short[] masks;
    private int count;
    private int mark;

    public TokenScanner(GrammarIndexer indexer, String resource, char[] original, char[] source, short[] lines, short[] types) {
        this.indexer = new TokenIndexer(indexer, resource, original, source, lines, types);
        this.tokens = new ArrayList<Token>();
        this.count = source.length;
    }

    @Override
    public Token<String> text() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.TEXT.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<String> template() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.TEMPLATE.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<String> type() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.TYPE.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<String> identifier() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.IDENTIFIER.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<String> qualifier() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.QUALIFIER.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<Character> space() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.SPACE.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<String> literal(String text) {
        Token token;
        Object value;
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.LITERAL.mask) != 0 && (value = (token = this.tokens.get(this.mark)).getValue()) == text) {
            ++this.mark;
            return token;
        }
        return null;
    }

    @Override
    public Token<Number> binary() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.BINARY.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<Number> hexidecimal() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.HEXIDECIMAL.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Token<Number> decimal() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length && (this.masks[this.mark] & TokenType.DECIMAL.mask) != 0) {
            return this.tokens.get(this.mark++);
        }
        return null;
    }

    @Override
    public Line line(int position) {
        int length = this.tokens.size();
        int index = Math.min(length - 1, position);
        Token token = this.tokens.get(index);
        if (token != null) {
            return token.getLine();
        }
        return null;
    }

    @Override
    public int peek() {
        if (this.masks == null) {
            this.masks = this.indexer.index(this.tokens);
        }
        if (this.mark < this.masks.length) {
            return this.masks[this.mark];
        }
        return 0;
    }

    @Override
    public int reset(int position) {
        int current = this.mark;
        if (position <= this.count || position >= 0) {
            this.mark = position;
        }
        return current;
    }

    @Override
    public int count() {
        return this.tokens.size();
    }

    @Override
    public int mark() {
        return this.mark;
    }
}

