/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.convert.CompatibilityChecker;
import org.snapscript.core.error.ErrorCauseExtractor;
import org.snapscript.core.function.Parameter;
import org.snapscript.tree.CatchBlock;
import org.snapscript.tree.function.ParameterDeclaration;

public class CatchBlockList {
    private final ErrorCauseExtractor extractor = new ErrorCauseExtractor();
    private final CompatibilityChecker checker = new CompatibilityChecker();
    private final CatchBlock[] blocks;

    public CatchBlockList(CatchBlock ... blocks) {
        this.blocks = blocks;
    }

    public Result compile(Scope scope) throws Exception {
        for (CatchBlock block : this.blocks) {
            Statement statement = block.getStatement();
            if (statement == null) continue;
            statement.compile(scope);
        }
        return ResultType.getNormal();
    }

    public Result execute(Scope scope, Result result) throws Exception {
        Object data = result.getValue();
        for (CatchBlock block : this.blocks) {
            Object cause;
            ParameterDeclaration declaration = block.getDeclaration();
            Statement statement = block.getStatement();
            Parameter parameter = declaration.get(scope);
            Type type = parameter.getType();
            String name = parameter.getName();
            if (data == null || !this.checker.compatible(scope, cause = this.extractor.extract(scope, data), type)) continue;
            Scope compound = scope.getInner();
            State state = compound.getState();
            Value constant = ValueType.getConstant(cause);
            state.add(name, constant);
            return statement.execute(compound);
        }
        return result;
    }
}

