/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Evaluation;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Value;
import org.snapscript.tree.DeclarationAllocator;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.constraint.Constraint;
import org.snapscript.tree.literal.TextLiteral;

public class Declaration {
    private final DeclarationAllocator allocator;
    private final NameReference reference;

    public Declaration(TextLiteral identifier) {
        this(identifier, null, null);
    }

    public Declaration(TextLiteral identifier, Constraint constraint) {
        this(identifier, constraint, null);
    }

    public Declaration(TextLiteral identifier, Evaluation value) {
        this(identifier, null, value);
    }

    public Declaration(TextLiteral identifier, Constraint constraint, Evaluation value) {
        this.allocator = new DeclarationAllocator(constraint, value);
        this.reference = new NameReference(identifier);
    }

    public Value create(Scope scope, int modifiers) throws Exception {
        String name = this.reference.getName(scope);
        Value value = this.allocator.allocate(scope, name, modifiers);
        State state = scope.getState();
        try {
            state.add(name, value);
        }
        catch (Exception e) {
            throw new InternalStateException("Declaration of variable '" + name + "' failed", e);
        }
        return value;
    }
}

