/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Evaluation;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.tree.DeclarationConverter;
import org.snapscript.tree.constraint.Constraint;
import org.snapscript.tree.constraint.ConstraintReference;

public class DeclarationAllocator {
    private final DeclarationConverter converter;
    private final ConstraintReference extractor;
    private final Evaluation expression;

    public DeclarationAllocator(Constraint constraint, Evaluation expression) {
        this.extractor = new ConstraintReference(constraint);
        this.converter = new DeclarationConverter();
        this.expression = expression;
    }

    public Value allocate(Scope scope, String name, int modifiers) throws Exception {
        Type type = this.extractor.getConstraint(scope);
        Object object = null;
        if (this.expression != null) {
            Value value = this.expression.evaluate(scope, null);
            Object original = value.getValue();
            object = type != null ? this.converter.convert(scope, original, type, name) : (Object)original;
        }
        return this.create(scope, object, type, modifiers);
    }

    protected Value create(Scope scope, Object value, Type type, int modifiers) throws Exception {
        if (ModifierType.isConstant(modifiers)) {
            return ValueType.getConstant(value, type);
        }
        return ValueType.getReference(value, type);
    }
}

