/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Module;
import org.snapscript.core.Path;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Value;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.trace.TraceType;

public class ExpressionStatement
implements Compilation {
    private final Statement expression;

    public ExpressionStatement(Evaluation expression) {
        this.expression = new CompileResult(expression);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = TraceType.getNormal(module, path, line);
        return new TraceStatement(interceptor, handler, this.expression, trace);
    }

    private static class CompileResult
    extends Statement {
        private final Evaluation expression;

        public CompileResult(Evaluation expression) {
            this.expression = expression;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Value reference = this.expression.evaluate(scope, null);
            Object value = reference.getValue();
            return ResultType.getNormal(value);
        }
    }
}

