/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.NameBuilder;
import org.snapscript.core.NoStatement;
import org.snapscript.core.Path;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.TypeNameBuilder;
import org.snapscript.core.Value;
import org.snapscript.core.link.ImportManager;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageDefinition;
import org.snapscript.tree.Qualifier;

public class Import
implements Compilation {
    private final Qualifier qualifier;
    private final Evaluation alias;

    public Import(Qualifier qualifier) {
        this(qualifier, null);
    }

    public Import(Qualifier qualifier, Evaluation alias) {
        this.qualifier = qualifier;
        this.alias = alias;
    }

    @Override
    public Object compile(Module module, Path path, int line) throws Exception {
        Package library;
        Context context = module.getContext();
        TypeLoader loader = context.getLoader();
        String location = this.qualifier.getLocation();
        String target = this.qualifier.getTarget();
        String name = this.qualifier.getName();
        if (target == null && (library = loader.importPackage(location)) != null) {
            return new CompileResult(library, path, location, null, name);
        }
        library = loader.importType(location, target);
        if (library != null) {
            if (this.alias != null) {
                Scope scope = module.getScope();
                Value value = this.alias.evaluate(scope, null);
                String alias = value.getString();
                return new CompileResult(library, path, location, target, alias);
            }
            return new CompileResult(library, path, location, target, target, name);
        }
        return new NoStatement();
    }

    private static class CompileResult
    extends Statement {
        private PackageDefinition definition;
        private NameBuilder builder = new TypeNameBuilder();
        private Statement statement;
        private Package library;
        private String location;
        private String target;
        private Path path;
        private String[] alias;

        public CompileResult(Package library, Path path, String location, String target, String ... alias) {
            this.location = location;
            this.library = library;
            this.target = target;
            this.alias = alias;
            this.path = path;
        }

        @Override
        public Result define(Scope scope) throws Exception {
            if (this.library == null) {
                throw new InternalStateException("Import '" + this.location + "' was not loaded");
            }
            if (this.definition == null) {
                this.definition = this.create(scope);
            }
            return ResultType.getNormal();
        }

        @Override
        public Result compile(Scope scope) throws Exception {
            if (this.definition == null) {
                throw new InternalStateException("Import '" + this.location + "' was not defined");
            }
            if (this.statement == null) {
                this.statement = this.definition.compile(scope, this.path);
            }
            return ResultType.getNormal();
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            if (this.statement == null) {
                throw new InternalStateException("Import '" + this.location + "' was not compiled");
            }
            return this.statement.execute(scope);
        }

        private PackageDefinition create(Scope scope) throws Exception {
            Module module = scope.getModule();
            ImportManager manager = module.getManager();
            String type = this.builder.createFullName(this.location, this.target);
            if (this.target == null) {
                manager.addImport(this.location);
            } else if (this.alias != null) {
                for (String name : this.alias) {
                    if (name == null) continue;
                    manager.addImport(type, name);
                }
            } else {
                manager.addImport(type, this.target);
            }
            return this.library.define(scope);
        }
    }
}

