/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import java.util.List;
import org.snapscript.core.Compilation;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Module;
import org.snapscript.core.NameBuilder;
import org.snapscript.core.Path;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.core.TypeNameBuilder;
import org.snapscript.core.function.Function;
import org.snapscript.tree.Qualifier;

public class ImportStatic
implements Compilation {
    private final Qualifier qualifier;

    public ImportStatic(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public Object compile(Module module, Path path, int line) throws Exception {
        String location = this.qualifier.getLocation();
        String target = this.qualifier.getTarget();
        String name = this.qualifier.getName();
        return new CompileResult(location, target, name);
    }

    private static class CompileResult
    extends Statement {
        private final NameBuilder builder = new TypeNameBuilder();
        private final String location;
        private final String target;
        private final String prefix;

        public CompileResult(String location, String target, String prefix) {
            this.location = location;
            this.target = target;
            this.prefix = prefix;
        }

        @Override
        public Result compile(Scope scope) throws Exception {
            Module module = scope.getModule();
            String parent = this.builder.createFullName(this.location, this.target);
            Type type = module.getType(parent);
            List<Function> methods = type.getFunctions();
            List<Function> functions = module.getFunctions();
            for (Function method : methods) {
                int modifiers = method.getModifiers();
                if (!ModifierType.isStatic(modifiers) || !ModifierType.isPublic(modifiers)) continue;
                String name = method.getName();
                if (this.prefix != null && !this.prefix.equals(name)) continue;
                functions.add(method);
            }
            return ResultType.getNormal();
        }
    }
}

