/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.Context;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.tree.Instruction;
import org.snapscript.tree.Operation;

public class OperationResolver {
    private final Cache<String, Operation> registry = new CopyOnWriteCache<String, Operation>();
    private final Context context;

    public OperationResolver(Context context) {
        this.context = context;
    }

    public Operation resolve(String name) throws Exception {
        Operation current = this.registry.fetch(name);
        if (current == null) {
            Instruction[] list = Instruction.values();
            int size = this.registry.size();
            if (size < list.length) {
                for (Instruction instruction : list) {
                    Operation operation = this.create(instruction);
                    String grammar = instruction.getName();
                    this.registry.cache(grammar, operation);
                }
            }
            return this.registry.fetch(name);
        }
        return current;
    }

    private Operation create(Instruction instruction) throws Exception {
        TypeLoader loader = this.context.getLoader();
        Class value = instruction.getType();
        Type type = loader.loadType(value);
        return new Operation(instruction, type);
    }
}

