/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.define.Instance;
import org.snapscript.core.function.Function;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.parse.StringToken;

public class Super
implements Evaluation {
    private final StringToken token;

    public Super(StringToken token) {
        this.token = token;
    }

    @Override
    public Value evaluate(Scope scope, Object left) throws Exception {
        Module module = scope.getModule();
        Context context = module.getContext();
        ThreadStack stack = context.getStack();
        Function function = stack.current();
        if (function == null) {
            throw new InternalStateException("No enclosing function for 'super' reference");
        }
        State state = scope.getState();
        Value value = state.get("this");
        if (value == null) {
            throw new InternalStateException("No enclosing type for 'super' reference");
        }
        Instance instance = (Instance)value.getValue();
        Instance base = this.resolve(instance, function);
        if (base == null) {
            throw new InternalStateException("Illegal reference to 'super'");
        }
        return ValueType.getTransient(base);
    }

    private Instance resolve(Instance instance, Function function) {
        Type location = function.getType();
        for (Instance next = instance; next != null; next = next.getSuper()) {
            Type actual = next.getHandle();
            if (location != actual) continue;
            return next.getSuper();
        }
        return null;
    }
}

