/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.tree.CatchBlockList;

public class TryStatement
extends Statement {
    private final Statement statement;
    private final Statement finish;
    private final CatchBlockList list;

    public TryStatement(Statement statement, Statement finish) {
        this(statement, null, finish);
    }

    public TryStatement(Statement statement, CatchBlockList list) {
        this(statement, list, null);
    }

    public TryStatement(Statement statement, CatchBlockList list, Statement finish) {
        this.statement = statement;
        this.finish = finish;
        this.list = list;
    }

    @Override
    public Result compile(Scope scope) throws Exception {
        if (this.list != null) {
            this.list.compile(scope);
        }
        if (this.finish != null) {
            this.finish.compile(scope);
        }
        return this.statement.compile(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Scope scope) throws Exception {
        Result result = this.handle(scope);
        try {
            if (this.list != null && result.isThrow()) {
                Result result2 = this.list.execute(scope, result);
                return result2;
            }
        }
        finally {
            if (this.finish != null) {
                this.finish.execute(scope);
            }
        }
        return result;
    }

    private Result handle(Scope scope) throws Exception {
        try {
            return this.statement.execute(scope);
        }
        catch (Throwable cause) {
            return ResultType.getThrow(cause);
        }
    }
}

