/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.closure;

import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.core.Compilation;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Module;
import org.snapscript.core.Path;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.closure.ClosureScopeExtractor;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Signature;
import org.snapscript.tree.Expression;
import org.snapscript.tree.ExpressionStatement;
import org.snapscript.tree.closure.ClosureBuilder;
import org.snapscript.tree.closure.ClosureParameterList;

public class Closure
implements Compilation {
    private final ClosureParameterList parameters;
    private final ExpressionStatement compilation;
    private final Statement statement;

    public Closure(ClosureParameterList parameters, Statement statement) {
        this(parameters, statement, null);
    }

    public Closure(ClosureParameterList parameters, Expression expression) {
        this(parameters, null, expression);
    }

    public Closure(ClosureParameterList parameters, Statement statement, Expression expression) {
        this.compilation = new ExpressionStatement(expression);
        this.parameters = parameters;
        this.statement = statement;
    }

    @Override
    public Evaluation compile(Module module, Path path, int line) throws Exception {
        Statement closure = this.statement;
        if (closure == null) {
            closure = this.compilation.compile(module, path, line);
        }
        return new CompileResult(this.parameters, closure, module);
    }

    private static class CompileResult
    implements Evaluation {
        private final ClosureScopeExtractor extractor;
        private final ClosureParameterList parameters;
        private final ClosureBuilder builder;
        private final AtomicBoolean compile;
        private final Statement closure;
        private final Module module;

        public CompileResult(ClosureParameterList parameters, Statement closure, Module module) {
            this.builder = new ClosureBuilder(closure, module);
            this.extractor = new ClosureScopeExtractor();
            this.compile = new AtomicBoolean();
            this.parameters = parameters;
            this.closure = closure;
            this.module = module;
        }

        @Override
        public Value evaluate(Scope scope, Object left) throws Exception {
            Scope parent = this.module.getScope();
            Signature signature = this.parameters.create(parent);
            Scope capture = this.extractor.extract(scope);
            Function function = this.builder.create(signature, capture);
            if (this.compile.compareAndSet(false, true)) {
                this.closure.compile(capture);
            }
            return ValueType.getTransient(function);
        }
    }
}

