/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.collection;

import java.util.List;
import java.util.Map;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Value;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.tree.Argument;
import org.snapscript.tree.collection.CollectionConverter;
import org.snapscript.tree.collection.ListValue;
import org.snapscript.tree.collection.MapValue;

public class CollectionIndex
implements Evaluation {
    private final CollectionConverter converter = new CollectionConverter();
    private final Evaluation[] evaluations;
    private final Evaluation variable;
    private final Argument argument;

    public CollectionIndex(Evaluation variable, Argument argument, Evaluation ... evaluations) {
        this.evaluations = evaluations;
        this.argument = argument;
        this.variable = variable;
    }

    @Override
    public Value evaluate(Scope scope, Object left) throws Exception {
        Value value = this.variable.evaluate(scope, left);
        Value index = this.argument.evaluate(scope, null);
        Object source = value.getValue();
        if (source == null) {
            throw new InternalArgumentException("Illegal index of null");
        }
        Value result = this.index(scope, source, index);
        for (Evaluation evaluation : this.evaluations) {
            Object object = result.getValue();
            if (object == null) {
                throw new InternalStateException("Result was null");
            }
            result = evaluation.evaluate(scope, object);
        }
        return result;
    }

    private Value index(Scope scope, Object left, Value index) throws Exception {
        Module module = scope.getModule();
        Context context = module.getContext();
        ProxyWrapper wrapper = context.getWrapper();
        Object source = this.converter.convert(left);
        Class<?> type = left.getClass();
        if (List.class.isInstance(source)) {
            Integer number = index.getInteger();
            List list = (List)source;
            return new ListValue(wrapper, list, number);
        }
        if (Map.class.isInstance(source)) {
            Object key = index.getValue();
            Map map = (Map)source;
            return new MapValue(wrapper, map, key);
        }
        throw new InternalArgumentException("Illegal index of " + type);
    }
}

