/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.collection;

import org.snapscript.core.InternalArgumentException;
import org.snapscript.tree.collection.ArrayWrapper;

public class PrimitiveByteList
extends ArrayWrapper<Object> {
    private final byte[] array;
    private final int length;

    public PrimitiveByteList(byte[] array) {
        this.length = array.length;
        this.array = array;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public Object set(int index, Object value) {
        Byte previous = this.array[index];
        Class<?> type = value.getClass();
        if (type == String.class) {
            String text = (String)value;
            this.array[index] = Byte.parseByte(text);
        } else {
            Number number = (Number)value;
            this.array[index] = number.byteValue();
        }
        return previous;
    }

    @Override
    public Object[] toArray() {
        Object[] copy = new Byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            copy[i] = this.array[i];
        }
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] copy) {
        Class<?> type = copy.getClass();
        int require = copy.length;
        for (int i = 0; i < this.length && i < require; ++i) {
            Byte number = this.array[i];
            Object value = number;
            if (type != Byte[].class) {
                if (type == Short[].class) {
                    value = number.shortValue();
                } else if (type == Double[].class) {
                    value = number.doubleValue();
                } else if (type == Float[].class) {
                    value = Float.valueOf(number.floatValue());
                } else if (type == Long[].class) {
                    value = number.longValue();
                } else if (type == Integer[].class) {
                    value = number.intValue();
                } else if (type == String[].class) {
                    value = number.toString();
                } else if (type == Object[].class) {
                    value = number;
                } else {
                    throw new InternalArgumentException("Incompatible array type");
                }
            }
            copy[i] = value;
        }
        return copy;
    }

    @Override
    public int indexOf(Object object) {
        Class<?> type = object.getClass();
        for (int i = 0; i < this.length; ++i) {
            Byte number = this.array[i];
            Object value = number;
            if (type != Byte.class) {
                if (type == Float.class) {
                    value = Float.valueOf(number.floatValue());
                } else if (type == Short.class) {
                    value = number.shortValue();
                } else if (type == Double.class) {
                    value = number.doubleValue();
                } else if (type == Long.class) {
                    value = number.longValue();
                } else if (type == Integer.class) {
                    value = number.intValue();
                } else if (type == String.class) {
                    value = number.toString();
                } else {
                    throw new InternalArgumentException("Incompatible value type");
                }
            }
            if (!object.equals(value)) continue;
            return i;
        }
        return -1;
    }
}

