/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.collection;

import org.snapscript.core.InternalArgumentException;
import org.snapscript.tree.collection.ArrayWrapper;

public class PrimitiveCharacterList
extends ArrayWrapper<Character> {
    private final char[] array;
    private final int length;

    public PrimitiveCharacterList(char[] array) {
        this.length = array.length;
        this.array = array;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.array[index]);
    }

    @Override
    public Character set(int index, Character value) {
        Character previous = Character.valueOf(this.array[index]);
        this.array[index] = value.charValue();
        return previous;
    }

    @Override
    public Object[] toArray() {
        Object[] copy = new Character[this.length];
        for (int i = 0; i < this.length; ++i) {
            copy[i] = Character.valueOf(this.array[i]);
        }
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] copy) {
        Class<?> type = copy.getClass();
        int require = copy.length;
        for (int i = 0; i < this.length && i < require; ++i) {
            Character character = Character.valueOf(this.array[i]);
            Object value = character;
            if (type == String[].class) {
                value = value.toString();
            } else if (type == Character[].class) {
                value = character;
            } else if (type == Object[].class) {
                value = character;
            } else {
                throw new InternalArgumentException("Incompatible array type");
            }
            copy[i] = value;
        }
        return copy;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            Character value = Character.valueOf(this.array[i]);
            if (!object.equals(value)) continue;
            return i;
        }
        return -1;
    }
}

