/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.BooleanValue;
import org.snapscript.core.Scope;
import org.snapscript.core.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.condition.RelationalChecker;
import org.snapscript.tree.condition.ValueComparator;

public enum RelationalOperator {
    SAME("==="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (first == (second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    NOT_SAME("!=="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (first != (second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    EQUALS("=="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) == 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    NOT_EQUALS("!="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) != 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    GREATER(">"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) > 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    GREATER_OR_EQUALS(">="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) >= 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    LESS("<"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) < 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    LESS_OR_EQUALS("<="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) <= 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    MATCH("=~"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (this.checker.isMatch(scope, first, second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    NOT_MATCH("!=~"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (!this.checker.isMatch(scope, first, second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    INSTANCE_OF("instanceof"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (this.checker.isInstance(scope, first, second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    NOT_INSTANCE_OF("!instanceof"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (!this.checker.isInstance(scope, first, second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    };

    public final RelationalChecker checker = new RelationalChecker();
    public final String operator;

    private RelationalOperator(String operator) {
        this.operator = operator;
    }

    public abstract Value operate(Scope var1, Value var2, Value var3);

    public static RelationalOperator resolveOperator(StringToken token) {
        if (token != null) {
            RelationalOperator[] operators;
            String value = token.getValue();
            for (RelationalOperator operator : operators = RelationalOperator.values()) {
                if (!operator.operator.equals(value)) continue;
                return operator;
            }
        }
        return null;
    }
}

