/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Value;

public enum ValueComparator {
    NUMERIC{

        @Override
        public int compare(Value left, Value right) {
            Double secondary;
            Double primary = left.getDouble();
            if (primary != (secondary = right.getDouble())) {
                if (primary != null && secondary != null) {
                    return primary.compareTo(secondary);
                }
                return primary == null ? -1 : 1;
            }
            return 0;
        }
    }
    ,
    COMPARABLE{

        @Override
        public int compare(Value left, Value right) {
            Comparable secondary;
            Comparable primary = (Comparable)left.getValue();
            if (primary != (secondary = (Comparable)right.getValue())) {
                if (primary != null && secondary != null) {
                    return primary.compareTo(secondary);
                }
                return primary == null ? -1 : 1;
            }
            return 0;
        }
    }
    ,
    OBJECT{

        @Override
        public int compare(Value left, Value right) {
            Object secondary;
            Object primary = left.getValue();
            if (primary != (secondary = right.getValue())) {
                if (primary != null && secondary != null) {
                    if (primary.equals(secondary)) {
                        return 0;
                    }
                    return -1;
                }
                return primary == null ? -1 : 1;
            }
            return 0;
        }
    };


    public abstract int compare(Value var1, Value var2);

    public static ValueComparator resolveComparator(Value left, Value right) {
        Object primary = left.getValue();
        Object secondary = right.getValue();
        if (primary != null && secondary != null) {
            if (primary instanceof Number && secondary instanceof Number) {
                return NUMERIC;
            }
            if (Comparable.class == primary && Comparable.class == secondary) {
                return COMPARABLE;
            }
        }
        return OBJECT;
    }
}

