/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.construct;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.Module;
import org.snapscript.core.Path;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceEvaluation;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceType;
import org.snapscript.tree.Argument;
import org.snapscript.tree.collection.ArrayBuilder;

public class ConstructArray
implements Compilation {
    private final Evaluation construct;

    public ConstructArray(Evaluation type, Argument ... arguments) {
        this.construct = new CompileResult(type, arguments);
    }

    @Override
    public Evaluation compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = TraceType.getConstruct(module, path, line);
        return new TraceEvaluation(interceptor, this.construct, trace);
    }

    private static class CompileResult
    implements Evaluation {
        private final ArrayBuilder builder = new ArrayBuilder();
        private final Argument[] arguments;
        private final Evaluation reference;

        public CompileResult(Evaluation reference, Argument ... arguments) {
            this.reference = reference;
            this.arguments = arguments;
        }

        @Override
        public Value evaluate(Scope scope, Object left) throws Exception {
            Value value = this.reference.evaluate(scope, null);
            Type type = (Type)value.getValue();
            Class entry = type.getType();
            if (this.arguments.length > 0) {
                int first;
                int[] dimensions = new int[]{0, 0, 0};
                for (int i = 0; i < this.arguments.length; ++i) {
                    Argument argument = this.arguments[i];
                    Value index = argument.evaluate(scope, left);
                    Integer number = index.getInteger();
                    dimensions[i] = number;
                }
                if (this.arguments.length == 1) {
                    int size = dimensions[0];
                    Object array = this.builder.create(entry, size);
                    return ValueType.getTransient(array);
                }
                if (this.arguments.length == 2) {
                    first = dimensions[0];
                    int second = dimensions[1];
                    Object array = this.builder.create(entry, first, second);
                    return ValueType.getTransient(array);
                }
                if (this.arguments.length == 3) {
                    first = dimensions[0];
                    int second = dimensions[1];
                    int third = dimensions[2];
                    Object array = this.builder.create(entry, first, second, third);
                    return ValueType.getTransient(array);
                }
                throw new InternalArgumentException("Maximum of three dimensions exceeded");
            }
            Object array = this.builder.create(entry, 0);
            return ValueType.getTransient(array);
        }
    }
}

