/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.construct;

import java.util.ArrayList;
import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Module;
import org.snapscript.core.Path;
import org.snapscript.core.Scope;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceEvaluation;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceType;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.ArgumentList;

public class ConstructList
implements Compilation {
    private final Evaluation construct;

    public ConstructList(StringToken token) {
        this(null, token);
    }

    public ConstructList(ArgumentList arguments) {
        this(arguments, null);
    }

    public ConstructList(ArgumentList arguments, StringToken token) {
        this.construct = new CompileResult(arguments);
    }

    @Override
    public Evaluation compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = TraceType.getConstruct(module, path, line);
        return new TraceEvaluation(interceptor, this.construct, trace);
    }

    private static class CompileResult
    implements Evaluation {
        private final ArgumentList arguments;

        public CompileResult(ArgumentList arguments) {
            this.arguments = arguments;
        }

        @Override
        public Value evaluate(Scope scope, Object left) throws Exception {
            ArrayList<Object> result = new ArrayList<Object>();
            if (this.arguments != null) {
                Object[] array;
                Value reference = this.arguments.create(scope);
                Module module = scope.getModule();
                Context context = module.getContext();
                ProxyWrapper wrapper = context.getWrapper();
                for (Object value : array = (Object[])reference.getValue()) {
                    Object proxy = wrapper.toProxy(value);
                    result.add(proxy);
                }
            }
            return ValueType.getTransient(result);
        }
    }
}

