/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.Context;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.define.Instance;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.tree.define.AnyFunctionBuilder;
import org.snapscript.tree.define.AnyInstanceBuilder;

public class AnyDefinition {
    private final AnyFunctionBuilder builder = new AnyFunctionBuilder();

    public Type create(Scope scope) throws Exception {
        Module module = scope.getModule();
        Context context = module.getContext();
        TypeLoader loader = context.getLoader();
        Type result = loader.defineType("default", "Any");
        List<Function> functions = result.getFunctions();
        if (functions.isEmpty()) {
            Function constructor = this.builder.create(result, "new", NewInvocation.class, Type.class);
            Function hashCode = this.builder.create(result, "hashCode", HashCodeInvocation.class, new Class[0]);
            Function toString = this.builder.create(result, "toString", ToStringInvocation.class, new Class[0]);
            Function equals = this.builder.create(result, "equals", EqualsInvocation.class, Object.class);
            Function wait = this.builder.create(result, "wait", WaitInvocation.class, new Class[0]);
            Function waitFor = this.builder.create(result, "wait", WaitForInvocation.class, Long.class);
            Function notify = this.builder.create(result, "notify", NotifyInvocation.class, new Class[0]);
            Function notifyAll = this.builder.create(result, "notifyAll", NotifyAllInvocation.class, new Class[0]);
            functions.add(constructor);
            functions.add(wait);
            functions.add(waitFor);
            functions.add(notify);
            functions.add(notifyAll);
            functions.add(hashCode);
            functions.add(equals);
            functions.add(toString);
        }
        return result;
    }

    private static class ToStringInvocation
    implements Invocation<Object> {
        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            String value = object.toString();
            int hash = object.hashCode();
            return ResultType.getNormal(value + "@" + hash);
        }
    }

    private static class EqualsInvocation
    implements Invocation<Object> {
        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            Object argument = list[0];
            boolean equal = object.equals(argument);
            return ResultType.getNormal(equal);
        }
    }

    private static class HashCodeInvocation
    implements Invocation<Object> {
        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            int hash = object.hashCode();
            return ResultType.getNormal(hash);
        }
    }

    private static class NotifyAllInvocation
    implements Invocation<Object> {
        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            object.notifyAll();
            return ResultType.getNormal();
        }
    }

    private static class NotifyInvocation
    implements Invocation<Object> {
        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            object.notify();
            return ResultType.getNormal();
        }
    }

    private static class WaitForInvocation
    implements Invocation<Object> {
        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            Number argument = (Number)list[0];
            long time = argument.longValue();
            object.wait(time);
            return ResultType.getNormal();
        }
    }

    private static class WaitInvocation
    implements Invocation<Object> {
        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            object.wait();
            return ResultType.getNormal();
        }
    }

    private static class NewInvocation
    implements Invocation<Object> {
        private final AnyInstanceBuilder builder = new AnyInstanceBuilder();

        @Override
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            Type real = (Type)list[0];
            Instance instance = this.builder.create(scope, real);
            State state = instance.getState();
            Value value = ValueType.getProperty(object, real, ModifierType.PUBLIC.mask | ModifierType.CONSTANT.mask);
            state.add("this", value);
            return ResultType.getNormal(instance);
        }
    }
}

