/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.ClassConstantBuilder;
import org.snapscript.tree.define.TypeHierarchy;
import org.snapscript.tree.define.TypeName;

public class ClassBuilder
extends Statement {
    private final ClassConstantBuilder builder = new ClassConstantBuilder();
    private final AnnotationList annotations;
    private final TypeHierarchy hierarchy;
    private final TypeName name;

    public ClassBuilder(AnnotationList annotations, TypeName name, TypeHierarchy hierarchy) {
        this.annotations = annotations;
        this.hierarchy = hierarchy;
        this.name = name;
    }

    @Override
    public Result define(Scope outer) throws Exception {
        Module module = outer.getModule();
        String alias = this.name.getName(outer);
        Type type = module.addType(alias);
        return ResultType.getNormal(type);
    }

    @Override
    public Result compile(Scope outer) throws Exception {
        Module module = outer.getModule();
        String alias = this.name.getName(outer);
        Type type = module.getType(alias);
        Scope scope = type.getScope();
        this.annotations.apply(scope, type);
        this.builder.declare(scope, type);
        this.hierarchy.update(scope, type);
        return ResultType.getNormal(type);
    }
}

