/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.property.ConstantPropertyBuilder;
import org.snapscript.core.property.Property;

public class ClassConstantBuilder {
    private final ConstantPropertyBuilder builder = new ConstantPropertyBuilder();

    public void declare(Scope scope, Type type) throws Exception {
        this.declareConstant(scope, "this", type);
        this.declareConstant(scope, "class", type, type);
    }

    protected void declareConstant(Scope scope, String name, Type type) throws Exception {
        List<Property> properties = type.getProperties();
        Property property = this.builder.createConstant(name);
        properties.add(property);
    }

    protected void declareConstant(Scope scope, String name, Type type, Object value) throws Exception {
        List<Property> properties = type.getProperties();
        Property property = this.builder.createConstant(name, value);
        Value constant = ValueType.getBlank(value, null, ModifierType.PUBLIC.mask | ModifierType.CONSTANT.mask);
        State state = scope.getState();
        properties.add(property);
        state.add(name, constant);
    }

    protected void declareConstant(Scope scope, String name, Type type, Type parent, Object value) throws Exception {
        List<Property> properties = type.getProperties();
        Property property = this.builder.createConstant(name, value, type);
        Value constant = ValueType.getBlank(value, parent, ModifierType.PUBLIC.mask | ModifierType.CONSTANT.mask);
        State state = scope.getState();
        properties.add(property);
        state.add(name, constant);
    }
}

