/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.tree.define.EnumConstantBuilder;
import org.snapscript.tree.define.TypeHierarchy;
import org.snapscript.tree.define.TypeName;

public class EnumBuilder
extends Statement {
    private final EnumConstantBuilder builder = new EnumConstantBuilder();
    private final TypeHierarchy hierarchy;
    private final TypeName name;
    private final List values = new ArrayList();

    public EnumBuilder(TypeName name, TypeHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.name = name;
    }

    @Override
    public Result define(Scope outer) throws Exception {
        Module module = outer.getModule();
        String alias = this.name.getName(outer);
        Type type = module.addType(alias);
        return ResultType.getNormal(type);
    }

    @Override
    public Result compile(Scope outer) throws Exception {
        Module module = outer.getModule();
        String alias = this.name.getName(outer);
        Type type = module.getType(alias);
        Scope scope = type.getScope();
        this.builder.declare(scope, type, this.values);
        this.hierarchy.update(scope, type);
        return ResultType.getNormal(type);
    }
}

