/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.DefaultConstructor;
import org.snapscript.tree.define.EnumBuilder;
import org.snapscript.tree.define.EnumList;
import org.snapscript.tree.define.TypeFactoryCollector;
import org.snapscript.tree.define.TypeHierarchy;
import org.snapscript.tree.define.TypeName;
import org.snapscript.tree.define.TypePart;

public class EnumDefinition
extends Statement {
    private final DefaultConstructor constructor;
    private final TypeFactoryCollector collector;
    private final AtomicBoolean compile;
    private final EnumBuilder builder;
    private final EnumList list;
    private final TypePart[] parts;

    public EnumDefinition(AnnotationList annotations, TypeName name, TypeHierarchy hierarchy, EnumList list, TypePart ... parts) {
        this.builder = new EnumBuilder(name, hierarchy);
        this.constructor = new DefaultConstructor(true);
        this.collector = new TypeFactoryCollector();
        this.compile = new AtomicBoolean(true);
        this.parts = parts;
        this.list = list;
    }

    @Override
    public Result define(Scope outer) throws Exception {
        return this.builder.define(outer);
    }

    @Override
    public Result compile(Scope outer) throws Exception {
        if (!this.compile.compareAndSet(false, true)) {
            Result result = this.builder.compile(outer);
            Type type = (Type)result.getValue();
            TypeFactory keys = this.list.compile(this.collector, type);
            Scope scope = type.getScope();
            for (TypePart part : this.parts) {
                TypeFactory factory = part.compile(this.collector, type);
                this.collector.update(factory);
            }
            this.constructor.compile(this.collector, type);
            keys.execute(scope, type);
            this.collector.compile(scope, type);
            return result;
        }
        return ResultType.getNormal();
    }
}

