/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.core.Value;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.tree.ArgumentList;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.define.EnumConstantBuilder;
import org.snapscript.tree.define.EnumConstructorBinder;
import org.snapscript.tree.define.EnumKey;

public class EnumFactory
extends TypeFactory {
    private final EnumConstantBuilder initializer = new EnumConstantBuilder();
    private final EnumConstructorBinder binder;
    private final NameReference reference;
    private final int index;

    public EnumFactory(EnumKey key, ArgumentList arguments, int index) {
        this.binder = new EnumConstructorBinder(arguments);
        this.reference = new NameReference(key);
        this.index = index;
    }

    @Override
    public Result execute(Scope scope, Type type) throws Exception {
        String name = this.reference.getName(scope);
        State state = scope.getState();
        if (type == null) {
            throw new InternalStateException("No type found for enum " + name);
        }
        Callable<Result> call = this.binder.bind(scope, type);
        Module module = scope.getModule();
        Context context = module.getContext();
        ProxyWrapper wrapper = context.getWrapper();
        if (call == null) {
            throw new InternalStateException("No constructor for enum '" + name + "' in '" + type + "'");
        }
        Result result = call.call();
        Scope instance = (Scope)result.getValue();
        Value value = state.get("values");
        List values = (List)value.getValue();
        Object object = wrapper.toProxy(instance);
        this.initializer.declareConstant(scope, name, type, type, instance);
        this.initializer.declareConstant(instance, "name", type, name);
        this.initializer.declareConstant(instance, "ordinal", type, this.index);
        values.add(object);
        return ResultType.getNormal(instance);
    }
}

