/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.function.AccessorProperty;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.index.PropertyNameExtractor;
import org.snapscript.core.property.Property;
import org.snapscript.tree.define.FunctionAccessor;

public class FunctionPropertyGenerator {
    private static final String[] PREFIXES = new String[]{"get", "set"};
    private static final int MODIFIERS = ModifierType.OVERRIDE.mask | ModifierType.ABSTRACT.mask;
    private final Set<String> done = new HashSet<String>();

    public void generate(Type type) throws Exception {
        List<Function> functions = type.getFunctions();
        List<Property> properties = type.getProperties();
        for (Property property : properties) {
            String name = property.getName();
            if (name == null) continue;
            this.done.add(name);
        }
        for (Function function : functions) {
            String name;
            Signature signature = function.getSignature();
            List<Parameter> names = signature.getParameters();
            int modifiers = function.getModifiers();
            int count = names.size();
            if (count != 0 || !this.done.add(name = this.extract(function))) continue;
            FunctionAccessor accessor = new FunctionAccessor(function);
            AccessorProperty<Scope> property = new AccessorProperty<Scope>(name, type, null, accessor, modifiers & ~MODIFIERS);
            properties.add(property);
        }
    }

    private String extract(Function function) throws Exception {
        String name = function.getName();
        for (String prefix : PREFIXES) {
            String property = PropertyNameExtractor.getProperty(name, prefix);
            if (property == null) continue;
            return property;
        }
        return name;
    }
}

