/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.InternalStateException;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.InvocationFunction;
import org.snapscript.core.function.Signature;
import org.snapscript.tree.define.InstanceInvocation;
import org.snapscript.tree.define.MemberFunctionBuilder;

public class InstanceFunctionBuilder
implements MemberFunctionBuilder {
    private final Signature signature;
    private final Statement body;
    private final Type constraint;
    private final String name;
    private final int modifiers;

    public InstanceFunctionBuilder(Signature signature, Statement body, Type constraint, String name, int modifiers) {
        this.constraint = constraint;
        this.modifiers = modifiers;
        this.signature = signature;
        this.body = body;
        this.name = name;
    }

    @Override
    public Function create(TypeFactory factory, Scope scope, Type type) {
        InstanceInvocation invocation = new InstanceInvocation(this.signature, this.body, this.constraint, this.name);
        InvocationFunction function = new InvocationFunction(this.signature, invocation, type, this.constraint, this.name, this.modifiers);
        if (!ModifierType.isAbstract(this.modifiers) && this.body == null) {
            throw new InternalStateException("Function '" + function + "' is not abstract");
        }
        return function;
    }
}

