/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.core.function.Function;
import org.snapscript.tree.ModifierList;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.ConstructorAssembler;
import org.snapscript.tree.define.ConstructorBuilder;
import org.snapscript.tree.define.TypePart;
import org.snapscript.tree.function.ParameterList;

public abstract class MemberConstructor
implements TypePart {
    private final ConstructorAssembler assembler;
    private final AnnotationList annotations;
    private final ModifierList list;
    private final Statement body;

    public MemberConstructor(AnnotationList annotations, ModifierList list, ParameterList parameters, Statement body) {
        this(annotations, list, parameters, null, body);
    }

    public MemberConstructor(AnnotationList annotations, ModifierList list, ParameterList parameters, TypePart part, Statement body) {
        this.assembler = new ConstructorAssembler(parameters, part, body);
        this.annotations = annotations;
        this.list = list;
        this.body = body;
    }

    @Override
    public TypeFactory define(TypeFactory factory, Type type) throws Exception {
        return null;
    }

    protected TypeFactory compile(TypeFactory factory, Type type, boolean compile) throws Exception {
        int modifiers = this.list.getModifiers();
        ConstructorBuilder builder = this.assembler.assemble(factory, type);
        Function constructor = builder.create(factory, type, modifiers, compile);
        List<Function> functions = type.getFunctions();
        Scope scope = type.getScope();
        this.annotations.apply(scope, constructor);
        functions.add(constructor);
        this.body.compile(scope);
        return null;
    }
}

