/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.core.function.Accessor;
import org.snapscript.core.function.AccessorProperty;
import org.snapscript.core.function.ScopeAccessor;
import org.snapscript.core.function.StaticAccessor;
import org.snapscript.core.property.Property;
import org.snapscript.tree.ModifierChecker;
import org.snapscript.tree.ModifierList;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.MemberFieldAssembler;
import org.snapscript.tree.define.MemberFieldData;
import org.snapscript.tree.define.MemberFieldDeclaration;
import org.snapscript.tree.define.TypeFactoryCollector;
import org.snapscript.tree.define.TypePart;

public class MemberField
implements TypePart {
    private final MemberFieldDeclaration[] declarations;
    private final TypeFactoryCollector collector;
    private final MemberFieldAssembler assembler;
    private final AnnotationList annotations;
    private final ModifierChecker checker;

    public MemberField(AnnotationList annotations, ModifierList modifiers, MemberFieldDeclaration ... declarations) {
        this.assembler = new MemberFieldAssembler(modifiers);
        this.checker = new ModifierChecker(modifiers);
        this.collector = new TypeFactoryCollector();
        this.declarations = declarations;
        this.annotations = annotations;
    }

    @Override
    public TypeFactory define(TypeFactory factory, Type type) throws Exception {
        return null;
    }

    @Override
    public TypeFactory compile(TypeFactory factory, Type type) throws Exception {
        Scope scope = type.getScope();
        List<Property> properties = type.getProperties();
        int mask = this.checker.getModifiers();
        for (MemberFieldDeclaration declaration : this.declarations) {
            AccessorProperty<Scope> property;
            Accessor<Scope> accessor;
            MemberFieldData data = declaration.create(scope);
            String name = data.getName();
            Type constraint = data.getConstraint();
            TypeFactory declare = this.assembler.assemble(data);
            if (this.checker.isStatic()) {
                accessor = new StaticAccessor(factory, scope, type, name);
                property = new AccessorProperty<Scope>(name, type, constraint, accessor, mask);
                this.annotations.apply(scope, property);
                properties.add(property);
            } else {
                accessor = new ScopeAccessor(name);
                property = new AccessorProperty<Scope>(name, type, constraint, accessor, mask);
                this.annotations.apply(scope, property);
                properties.add(property);
            }
            this.collector.update(declare);
        }
        return this.collector;
    }
}

