/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Evaluation;
import org.snapscript.core.Identity;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.core.Value;
import org.snapscript.tree.DeclarationAllocator;
import org.snapscript.tree.ModifierChecker;
import org.snapscript.tree.ModifierData;
import org.snapscript.tree.constraint.Constraint;
import org.snapscript.tree.define.InstanceFieldFactory;
import org.snapscript.tree.define.MemberFieldAllocator;
import org.snapscript.tree.define.MemberFieldData;
import org.snapscript.tree.define.StaticFieldFactory;

public class MemberFieldAssembler {
    private final ModifierChecker checker;

    public MemberFieldAssembler(ModifierData modifiers) {
        this.checker = new ModifierChecker(modifiers);
    }

    public TypeFactory assemble(MemberFieldData data) throws Exception {
        Evaluation declaration = this.create(data);
        if (this.checker.isStatic()) {
            return new StaticFieldFactory(declaration);
        }
        return new InstanceFieldFactory(declaration);
    }

    private Evaluation create(MemberFieldData data) throws Exception {
        int modifiers = this.checker.getModifiers();
        String name = data.getName();
        Type type = data.getConstraint();
        Evaluation declare = data.getValue();
        return new Declaration(name, type, declare, modifiers);
    }

    private static class Declaration
    implements Evaluation {
        private final DeclarationAllocator allocator;
        private final Constraint constraint;
        private final Evaluation value;
        private final String name;
        private final int modifiers;

        public Declaration(String name, Type type, Evaluation declare, int modifiers) {
            this.value = new Identity(type);
            this.constraint = new Constraint(this.value);
            this.allocator = new MemberFieldAllocator(this.constraint, declare);
            this.modifiers = modifiers;
            this.name = name;
        }

        @Override
        public Value evaluate(Scope scope, Object left) throws Exception {
            Value value = this.allocator.allocate(scope, this.name, this.modifiers);
            State state = scope.getState();
            try {
                state.add(this.name, value);
            }
            catch (Exception e) {
                throw new InternalStateException("Declaration of variable '" + this.name + "' failed", e);
            }
            return value;
        }
    }
}

