/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Evaluation;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.core.function.Signature;
import org.snapscript.tree.ModifierChecker;
import org.snapscript.tree.ModifierList;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.constraint.Constraint;
import org.snapscript.tree.constraint.ConstraintReference;
import org.snapscript.tree.define.InstanceFunctionBuilder;
import org.snapscript.tree.define.MemberFunctionBuilder;
import org.snapscript.tree.define.StaticFunctionBuilder;
import org.snapscript.tree.function.ParameterList;

public class MemberFunctionAssembler {
    private final ConstraintReference constraint;
    private final ParameterList parameters;
    private final ModifierChecker checker;
    private final NameReference identifier;
    private final ModifierList list;
    private final Statement body;

    public MemberFunctionAssembler(ModifierList list, Evaluation identifier, ParameterList parameters, Constraint constraint, Statement body) {
        this.constraint = new ConstraintReference(constraint);
        this.identifier = new NameReference(identifier);
        this.checker = new ModifierChecker(list);
        this.parameters = parameters;
        this.list = list;
        this.body = body;
    }

    public MemberFunctionBuilder assemble(Type type, int mask) throws Exception {
        Scope scope = type.getScope();
        String name = this.identifier.getName(scope);
        Signature signature = this.parameters.create(scope);
        Type returns = this.constraint.getConstraint(scope);
        int modifiers = mask | this.list.getModifiers();
        if (this.checker.isStatic()) {
            return new StaticFunctionBuilder(signature, this.body, returns, name, modifiers);
        }
        return new InstanceFunctionBuilder(signature, this.body, returns, name, modifiers);
    }
}

