/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;

public class ModuleBody
extends Statement {
    private final Statement[] statements;
    private final AtomicBoolean execute = new AtomicBoolean(true);
    private final AtomicBoolean compile = new AtomicBoolean(true);
    private final AtomicBoolean define = new AtomicBoolean(true);

    public ModuleBody(Statement ... statements) {
        this.statements = statements;
    }

    @Override
    public Result define(Scope scope) throws Exception {
        Result last = ResultType.getNormal();
        if (this.define.compareAndSet(true, false)) {
            for (Statement statement : this.statements) {
                Result result = statement.define(scope);
                if (!result.isNormal()) {
                    return result;
                }
                last = result;
            }
        }
        return last;
    }

    @Override
    public Result compile(Scope scope) throws Exception {
        Result last = ResultType.getNormal();
        if (this.compile.compareAndSet(true, false)) {
            for (Statement statement : this.statements) {
                Result result = statement.compile(scope);
                if (!result.isNormal()) {
                    return result;
                }
                last = result;
            }
        }
        return last;
    }

    @Override
    public Result execute(Scope scope) throws Exception {
        Result last = ResultType.getNormal();
        if (this.execute.compareAndSet(true, false)) {
            for (Statement statement : this.statements) {
                Result result = statement.execute(scope);
                if (!result.isNormal()) {
                    return result;
                }
                last = result;
            }
        }
        return last;
    }
}

