/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.ModuleRegistry;
import org.snapscript.core.Path;
import org.snapscript.core.Scope;
import org.snapscript.core.TypeNameBuilder;
import org.snapscript.core.link.ImportManager;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.ModuleName;

public class ModuleBuilder {
    private final AnnotationList annotations;
    private final TypeNameBuilder builder;
    private final NameReference reference;

    public ModuleBuilder(AnnotationList annotations, ModuleName module) {
        this.reference = new NameReference(module);
        this.builder = new TypeNameBuilder();
        this.annotations = annotations;
    }

    public Module create(Scope scope) throws Exception {
        String name = this.reference.getName(scope);
        Module parent = scope.getModule();
        Module module = this.create(parent, name);
        ImportManager manager = module.getManager();
        String include = parent.getName();
        this.annotations.apply(scope, module);
        manager.addImport(include);
        return module;
    }

    protected Module create(Module parent, String name) throws Exception {
        Path path = parent.getPath();
        String prefix = parent.getName();
        String type = this.builder.createFullName(prefix, name);
        Context context = parent.getContext();
        ImportManager manager = parent.getManager();
        ModuleRegistry registry = context.getRegistry();
        Module module = registry.addModule(type, path);
        manager.addImports(module);
        manager.addImport(type, name);
        return module;
    }
}

