/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Statement;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.ModuleBody;
import org.snapscript.tree.define.ModuleBuilder;
import org.snapscript.tree.define.ModuleName;

public class ModuleDefinition
extends Statement {
    private final AtomicReference<Module> reference;
    private final ModuleBuilder builder;
    private final Statement body;

    public ModuleDefinition(AnnotationList annotations, ModuleName module, Statement ... body) {
        this.builder = new ModuleBuilder(annotations, module);
        this.reference = new AtomicReference();
        this.body = new ModuleBody(body);
    }

    @Override
    public Result define(Scope scope) throws Exception {
        Module module = this.builder.create(scope);
        Scope inner = module.getScope();
        this.reference.set(module);
        return this.body.define(inner);
    }

    @Override
    public Result compile(Scope scope) throws Exception {
        Module module = this.reference.get();
        Value value = ValueType.getTransient(module);
        Scope inner = module.getScope();
        State state = inner.getState();
        state.add("this", value);
        return this.body.compile(inner);
    }

    @Override
    public Result execute(Scope scope) throws Exception {
        Module module = this.reference.get();
        Scope inner = module.getScope();
        return this.body.execute(inner);
    }
}

