/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.core.define.Instance;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.SignatureAligner;
import org.snapscript.tree.define.TypeAllocator;
import org.snapscript.tree.function.ParameterExtractor;

public class SuperAllocator
implements TypeAllocator {
    private final ParameterExtractor extractor;
    private final SignatureAligner aligner;
    private final TypeAllocator allocator;
    private final TypeFactory factory;

    public SuperAllocator(TypeFactory factory, TypeAllocator allocator, Signature signature) {
        this.extractor = new ParameterExtractor(signature);
        this.aligner = new SignatureAligner(signature);
        this.allocator = allocator;
        this.factory = factory;
    }

    @Override
    public Instance allocate(Scope scope, Instance object, Object ... list) throws Exception {
        Type real = (Type)list[0];
        Object[] arguments = this.aligner.align(list);
        Instance inner = object.getInner();
        if (arguments.length > 0) {
            this.extractor.extract(inner, arguments);
        }
        Result result = this.factory.execute(inner, real);
        Instance base = (Instance)result.getValue();
        return this.allocator.allocate(scope, base, list);
    }
}

