/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Evaluation;
import org.snapscript.core.Scope;
import org.snapscript.core.ScopeCombiner;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.tree.ArgumentList;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.define.SuperInstanceBuilder;
import org.snapscript.tree.define.SuperInvocationBinder;
import org.snapscript.tree.dispatch.InvocationDispatcher;

public class SuperInvocation
implements Evaluation {
    private final SuperInstanceBuilder builder;
    private final SuperInvocationBinder binder;
    private final NameReference reference;
    private final ArgumentList arguments;

    public SuperInvocation(Evaluation function, ArgumentList arguments, Type type) {
        this.binder = new SuperInvocationBinder(type);
        this.builder = new SuperInstanceBuilder(type);
        this.reference = new NameReference(function);
        this.arguments = arguments;
    }

    @Override
    public Value evaluate(Scope scope, Object left) throws Exception {
        Type real = scope.getType();
        String name = this.reference.getName(scope);
        Scope instance = this.builder.create(scope, left);
        InvocationDispatcher dispatcher = this.binder.bind(instance, null);
        if (this.arguments != null) {
            Scope outer = real.getScope();
            Scope compound = ScopeCombiner.combine(scope, outer);
            Value array = this.arguments.create(compound, real);
            Object[] list = (Object[])array.getValue();
            return dispatcher.dispatch(name, list);
        }
        return dispatcher.dispatch(name, real);
    }
}

