/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.core.Result;
import org.snapscript.core.ResultType;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.ClassBuilder;
import org.snapscript.tree.define.FunctionPropertyGenerator;
import org.snapscript.tree.define.StaticConstantFactory;
import org.snapscript.tree.define.TraitName;
import org.snapscript.tree.define.TypeFactoryCollector;
import org.snapscript.tree.define.TypeHierarchy;
import org.snapscript.tree.define.TypePart;

public class TraitDefinition
extends Statement {
    private final FunctionPropertyGenerator generator;
    private final TypeFactoryCollector collector;
    private final TypeFactory constants;
    private final AtomicBoolean compile;
    private final AtomicBoolean define;
    private final ClassBuilder builder;
    private final TypePart[] parts;

    public TraitDefinition(AnnotationList annotations, TraitName name, TypeHierarchy hierarchy, TypePart ... parts) {
        this.builder = new ClassBuilder(annotations, name, hierarchy);
        this.generator = new FunctionPropertyGenerator();
        this.constants = new StaticConstantFactory();
        this.collector = new TypeFactoryCollector();
        this.compile = new AtomicBoolean(true);
        this.define = new AtomicBoolean(true);
        this.parts = parts;
    }

    @Override
    public Result define(Scope outer) throws Exception {
        if (!this.define.compareAndSet(false, true)) {
            Result result = this.builder.define(outer);
            Type type = (Type)result.getValue();
            for (TypePart part : this.parts) {
                TypeFactory factory = part.define(this.collector, type);
                this.collector.update(factory);
            }
            return result;
        }
        return ResultType.getNormal();
    }

    @Override
    public Result compile(Scope outer) throws Exception {
        if (!this.compile.compareAndSet(false, true)) {
            Result result = this.builder.compile(outer);
            Type type = (Type)result.getValue();
            this.collector.update(this.constants);
            for (TypePart part : this.parts) {
                TypeFactory factory = part.compile(this.collector, type);
                this.collector.update(factory);
            }
            this.generator.generate(type);
            return result;
        }
        return ResultType.getNormal();
    }
}

