/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.tree.define.AnyDefinition;
import org.snapscript.tree.reference.TraitReference;
import org.snapscript.tree.reference.TypeReference;

public class TypeHierarchy {
    private final AnyDefinition definition = new AnyDefinition();
    private final TraitReference[] traits;
    private final TypeReference name;

    public TypeHierarchy(TraitReference ... traits) {
        this((TypeReference)null, traits);
    }

    public TypeHierarchy(TypeReference name, TraitReference ... traits) {
        this.traits = traits;
        this.name = name;
    }

    public void update(Scope scope, Type type) throws Exception {
        List<Type> types = type.getTypes();
        if (this.name != null) {
            Value value = this.name.evaluate(scope, null);
            Type base = (Type)value.getValue();
            if (base != null) {
                types.add(base);
            }
        } else {
            Type base = this.definition.create(scope);
            if (base != null) {
                types.add(base);
            }
        }
        for (int i = 0; i < this.traits.length; ++i) {
            Value value = this.traits[i].evaluate(scope, null);
            Type trait = (Type)value.getValue();
            if (trait == null) continue;
            types.add(trait);
        }
    }
}

