/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.dispatch;

import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.bind.FunctionBinder;
import org.snapscript.core.convert.Delegate;
import org.snapscript.tree.dispatch.InvocationDispatcher;

public class DelegateDispatcher
implements InvocationDispatcher {
    private final Delegate object;
    private final Scope scope;

    public DelegateDispatcher(Scope scope, Object object) {
        this.object = (Delegate)object;
        this.scope = scope;
    }

    @Override
    public Value dispatch(String name, Object ... arguments) throws Exception {
        Module module = this.scope.getModule();
        Context context = module.getContext();
        FunctionBinder binder = context.getBinder();
        Callable<Result> call = binder.bind(this.scope, this.object, name, arguments);
        if (call == null) {
            TypeExtractor extractor = context.getExtractor();
            Type type = extractor.getType(this.object);
            throw new InternalStateException("Method '" + name + "' not found for '" + type + "'");
        }
        Result result = call.call();
        Object value = result.getValue();
        return ValueType.getTransient(value);
    }
}

