/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.dispatch;

import java.util.List;
import java.util.concurrent.Callable;
import org.snapscript.core.Any;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.bind.FunctionBinder;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.Signature;
import org.snapscript.tree.dispatch.InvocationDispatcher;

public class FunctionDispatcher
implements InvocationDispatcher {
    private final FunctionAdapter adapter;
    private final Object function;
    private final Scope scope;

    public FunctionDispatcher(Scope scope, Object function) {
        this.adapter = new FunctionAdapter(function);
        this.function = function;
        this.scope = scope;
    }

    @Override
    public Value dispatch(String name, Object ... arguments) throws Exception {
        Callable<Result> call = this.bind(name, arguments);
        if (call == null) {
            throw new InternalStateException("Method '" + name + "' not found for function " + this.function + "");
        }
        Result result = call.call();
        Object value = result.getValue();
        return ValueType.getTransient(value);
    }

    private Callable<Result> bind(String name, Object ... arguments) throws Exception {
        Module module = this.scope.getModule();
        Context context = module.getContext();
        FunctionBinder binder = context.getBinder();
        Callable<Result> call = binder.bind(this.scope, this.function, name, arguments);
        if (call == null) {
            return binder.bind(this.scope, (Object)this.adapter, name, arguments);
        }
        return call;
    }

    private static class FunctionAdapter
    implements Any {
        private final Function function;

        public FunctionAdapter(Object function) {
            this.function = (Function)function;
        }

        public int getModifiers() {
            return this.function.getModifiers();
        }

        public Type getType() {
            return this.function.getType();
        }

        public Type getHandle() {
            return this.function.getHandle();
        }

        public Type getConstraint() {
            return this.function.getConstraint();
        }

        public String getName() {
            return this.function.getName();
        }

        public Signature getSignature() {
            return this.function.getSignature();
        }

        public List<Annotation> getAnnotations() {
            return this.function.getAnnotations();
        }

        public Invocation getInvocation() {
            return this.function.getInvocation();
        }

        public String getDescription() {
            return this.function.getDescription();
        }

        @Override
        public String toString() {
            return this.function.toString();
        }
    }
}

