/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.dispatch;

import java.util.Map;
import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.bind.FunctionBinder;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.tree.dispatch.InvocationDispatcher;

public class MapDispatcher
implements InvocationDispatcher {
    private final Object object;
    private final Scope scope;

    public MapDispatcher(Scope scope, Object object) {
        this.object = object;
        this.scope = scope;
    }

    @Override
    public Value dispatch(String name, Object ... arguments) throws Exception {
        Callable<Result> call = this.bind(name, arguments);
        if (call == null) {
            Module module = this.scope.getModule();
            Context context = module.getContext();
            TypeExtractor extractor = context.getExtractor();
            Type type = extractor.getType(this.object);
            throw new InternalStateException("Method '" + name + "' not found for '" + type + "'");
        }
        Result result = call.call();
        Object value = result.getValue();
        return ValueType.getTransient(value);
    }

    private Callable<Result> bind(String name, Object ... arguments) throws Exception {
        Map map;
        Object object;
        Module module = this.scope.getModule();
        Context context = module.getContext();
        FunctionBinder binder = context.getBinder();
        Callable<Result> local = binder.bind(this.scope, this.object, name, arguments);
        if (local == null && (object = (map = (Map)this.object).get(name)) != null) {
            ProxyWrapper wrapper = context.getWrapper();
            Object function = wrapper.fromProxy(object);
            Value reference = ValueType.getTransient(function);
            return binder.bind(reference, arguments);
        }
        return local;
    }
}

