/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.dispatch;

import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.bind.FunctionBinder;
import org.snapscript.tree.dispatch.InvocationDispatcher;

public class ModuleDispatcher
implements InvocationDispatcher {
    private final Module module;
    private final Object object;

    public ModuleDispatcher(Scope scope, Object object) {
        this.module = (Module)object;
        this.object = object;
    }

    @Override
    public Value dispatch(String name, Object ... arguments) throws Exception {
        Callable<Result> call = this.bind(name, arguments);
        if (call == null) {
            throw new InternalStateException("Method '" + name + "' not found for module '" + this.module + "'");
        }
        Result result = call.call();
        Object data = result.getValue();
        return ValueType.getTransient(data);
    }

    private Callable<Result> bind(String name, Object ... arguments) throws Exception {
        Scope scope = this.module.getScope();
        Context context = this.module.getContext();
        FunctionBinder binder = context.getBinder();
        Callable<Result> call = binder.bind(scope, this.module, name, arguments);
        if (call == null) {
            return binder.bind(scope, this.object, name, arguments);
        }
        return call;
    }
}

