/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.dispatch;

import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.bind.FunctionBinder;
import org.snapscript.tree.dispatch.InvocationDispatcher;

public class ScopeDispatcher
implements InvocationDispatcher {
    private final Scope object;
    private final Scope scope;

    public ScopeDispatcher(Scope scope, Object object) {
        this.object = (Scope)object;
        this.scope = scope;
    }

    @Override
    public Value dispatch(String name, Object ... arguments) throws Exception {
        Callable<Result> match = this.bind(name, arguments);
        if (match == null) {
            Module module = this.scope.getModule();
            Context context = module.getContext();
            TypeExtractor extractor = context.getExtractor();
            Type type = extractor.getType(this.object);
            throw new InternalStateException("Method '" + name + "' not found for '" + type + "'");
        }
        Result result = match.call();
        Object data = result.getValue();
        return ValueType.getTransient(data);
    }

    private Callable<Result> bind(String name, Object ... arguments) throws Exception {
        Module module = this.scope.getModule();
        Context context = module.getContext();
        FunctionBinder binder = context.getBinder();
        Callable<Result> local = binder.bind(this.scope, (Object)this.object, name, arguments);
        if (local == null) {
            Callable<Result> external = binder.bind(this.scope, module, name, arguments);
            if (external != null) {
                return external;
            }
            Callable<Result> closure = binder.bind(this.object, name, arguments);
            if (closure != null) {
                return closure;
            }
        }
        return local;
    }
}

