/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.function;

import java.util.ArrayList;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.ParameterBuilder;
import org.snapscript.core.function.Signature;
import org.snapscript.tree.function.ParameterDeclaration;
import org.snapscript.tree.function.VariableArgumentChecker;

public class ParameterList {
    private VariableArgumentChecker checker;
    private ParameterDeclaration[] list;
    private ParameterBuilder builder;
    private Signature signature;

    public ParameterList(ParameterDeclaration ... list) {
        this.checker = new VariableArgumentChecker(list);
        this.builder = new ParameterBuilder();
        this.list = list;
    }

    public Signature create(Scope scope) throws Exception {
        return this.create(scope, null);
    }

    public Signature create(Scope scope, String prefix) throws Exception {
        Module module = scope.getModule();
        if (this.signature == null) {
            Parameter parameter;
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            if (prefix != null) {
                Context context = module.getContext();
                TypeLoader loader = context.getLoader();
                Type constraint = loader.loadType(Type.class);
                parameter = this.builder.create(constraint, prefix);
                parameters.add(parameter);
            }
            boolean variable = this.checker.isVariable(scope);
            for (int i = 0; i < this.list.length; ++i) {
                ParameterDeclaration declaration = this.list[i];
                if (declaration == null) continue;
                parameter = declaration.get(scope);
                parameters.add(parameter);
            }
            this.signature = new Signature(parameters, module, null, variable);
        }
        return this.signature;
    }
}

