/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.Evaluation;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Scope;
import org.snapscript.core.Value;
import org.snapscript.core.convert.StringBuilder;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.operation.AssignmentOperator;

public class Assignment
implements Evaluation {
    private final AssignmentOperator operator;
    private final Evaluation left;
    private final Evaluation right;

    public Assignment(Evaluation left, StringToken operator, Evaluation right) {
        this.operator = AssignmentOperator.resolveOperator(operator);
        this.left = left;
        this.right = right;
    }

    @Override
    public Value evaluate(Scope scope, Object context) throws Exception {
        Object leftValue;
        Value leftResult = this.left.evaluate(scope, context);
        Value rightResult = this.right.evaluate(scope, context);
        if (this.operator != AssignmentOperator.EQUAL && !Number.class.isInstance(leftValue = leftResult.getValue())) {
            Object rightValue = rightResult.getValue();
            if (this.operator != AssignmentOperator.PLUS_EQUAL) {
                throw new InternalStateException("Operator " + (Object)((Object)this.operator) + " is illegal");
            }
            String leftText = StringBuilder.create(scope, leftValue);
            String rightText = StringBuilder.create(scope, rightValue);
            String text = leftText.concat(rightText);
            leftResult.setValue(text);
            return leftResult;
        }
        return this.operator.operate(scope, leftResult, rightResult);
    }
}

