/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.Evaluation;
import org.snapscript.core.Scope;
import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.core.convert.StringBuilder;
import org.snapscript.tree.operation.NumericChecker;
import org.snapscript.tree.operation.NumericOperator;

public class CalculationOperation
implements Evaluation {
    private final NumericOperator operator;
    private final Evaluation left;
    private final Evaluation right;

    public CalculationOperation(NumericOperator operator, Evaluation left, Evaluation right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Value evaluate(Scope scope, Object context) throws Exception {
        Object rightValue;
        Object leftValue;
        Value leftResult = this.left.evaluate(scope, null);
        Value rightResult = this.right.evaluate(scope, null);
        if (this.operator == NumericOperator.PLUS && !NumericChecker.bothNumeric(leftValue = leftResult.getValue(), rightValue = rightResult.getValue())) {
            String leftText = StringBuilder.create(scope, leftValue);
            String rightText = StringBuilder.create(scope, rightValue);
            String text = leftText.concat(rightText);
            return ValueType.getTransient(text);
        }
        return this.operator.operate(leftResult, rightResult);
    }
}

