/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.Evaluation;
import org.snapscript.tree.operation.CalculationOperation;
import org.snapscript.tree.operation.CalculationPart;
import org.snapscript.tree.operation.CalculatorStack;
import org.snapscript.tree.operation.NumericOperator;

public class Calculator {
    private final CalculatorStack<CalculationPart> tokens = new CalculatorStack();
    private final CalculatorStack<Evaluation> variables = new CalculatorStack();
    private final List<CalculationPart> order = new ArrayList<CalculationPart>();

    public Evaluation create() {
        while (!this.tokens.isEmpty()) {
            CalculationPart top = this.tokens.pop();
            if (top == null) continue;
            this.order.add(top);
        }
        for (CalculationPart token : this.order) {
            NumericOperator operator = token.getOperator();
            if (operator != null) {
                Evaluation right = this.variables.pop();
                Evaluation left = this.variables.pop();
                if (left == null || right == null) continue;
                CalculationOperation evaluation = new CalculationOperation(operator, left, right);
                this.variables.push(evaluation);
                continue;
            }
            Evaluation evaluation = token.getEvaluation();
            if (token == null) continue;
            this.variables.push(evaluation);
        }
        return this.variables.pop();
    }

    public void update(CalculationPart part) {
        NumericOperator operator = part.getOperator();
        if (operator != null) {
            while (!this.tokens.isEmpty()) {
                CalculationPart top = this.tokens.pop();
                NumericOperator other = top.getOperator();
                if (other.priority < operator.priority) {
                    this.tokens.push(top);
                    break;
                }
                this.order.add(top);
            }
            this.tokens.push(part);
        } else {
            this.order.add(part);
        }
    }
}

