/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.operation;

import org.snapscript.core.Value;
import org.snapscript.core.ValueType;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.operation.NumericConverter;

public enum PrefixOperator {
    NOT("!"){

        @Override
        public Value operate(Value right) {
            Boolean value = right.getBoolean();
            return ValueType.getTransient(value == false);
        }
    }
    ,
    COMPLEMENT("~"){

        @Override
        public Value operate(Value right) {
            Number value = right.getNumber();
            NumericConverter converter = NumericConverter.resolveConverter(value);
            Long number = value.longValue();
            return converter.convert(number ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
    ,
    PLUS("+"){

        @Override
        public Value operate(Value right) {
            Number value = right.getNumber();
            NumericConverter converter = NumericConverter.resolveConverter(value);
            Double number = value.doubleValue();
            return converter.convert((double)number);
        }
    }
    ,
    MINUS("-"){

        @Override
        public Value operate(Value right) {
            Number value = right.getNumber();
            NumericConverter converter = NumericConverter.resolveConverter(value);
            Double number = value.doubleValue();
            return converter.convert(-number.doubleValue());
        }
    };

    public final String operator;

    private PrefixOperator(String operator) {
        this.operator = operator;
    }

    public abstract Value operate(Value var1);

    public static PrefixOperator resolveOperator(StringToken token) {
        if (token != null) {
            PrefixOperator[] operators;
            String value = token.getValue();
            for (PrefixOperator operator : operators = PrefixOperator.values()) {
                if (!operator.operator.equals(value)) continue;
                return operator;
            }
        }
        return null;
    }
}

